
Type TPyramid

	Field referenceBody:TBody
	Field referenceGeom:TGeom
	
	Field blockBody:TBody[] 
	Field blockGeom:TGeom[] 
	
	Field horizontalSpacing:Float
	Field verticalSpacing:Float
	Field blockWidth:Float
	Field blockHeight:Float
	Field bottomRowBlockCount:Int
	Field bottomRightBlockPosition:Vector2 = Vector2.Zero() 
	
	Function Create:TPyramid(referenceBody:TBody, referenceGeom:TGeom, horizontalSpacing:Float, verticalSpacing:Float, blockWidth:Float, blockHeight:Float, bottomRowBlockCount:Int, bottomRightBlockPosition:Vector2) 
		Local p:TPyramid = New TPyramid
		p.referenceBody = referenceBody
		p.referenceGeom = referenceGeom
		p.horizontalSpacing = horizontalSpacing
		p.verticalSpacing = verticalSpacing
		p.blockWidth = blockwidth
		p.blockHeight = blockHeight
		p.bottomRowBlockCount = bottomRowBlockCount
		p.bottomRightBlockPosition = bottomRightBlockPosition.Copy() 
		Return p
	End Function
	
	Method Load(physics:TPhysicsSimulator) 
		Local count:Int = bottomRowBlockCount * (1 + bottomrowBlockCount) / 2
		blockBody = New TBody[count] 
		blockGeom = New TGeom[count] 
		
		For Local i:Int = 0 To blockBody.Length - 1
			blockBody[i] = TBodyFactory.CloneBody(physics, referenceBody) 
			blockGeom[i] = TGeomFactory.CloneGeom(physics, blockBody[i], referenceGeom)
		Next
		
		CreatePyramid() 
	End Method
	
	Method CreatePyramid() 
		Local rowOffset:Vector2 = Vector2.Create((blockWidth / 2) + (horizontalSpacing / 2), - (blockheight + verticalSpacing)) 
		Local colOffset:Vector2 = Vector2.Create(horizontalSpacing + blockWidth, 0) 
		Local position:Vector2 = Vector2.Zero() 
		Local blockCounter:Int = 0
		For Local i:Int = 0 To bottomRowBlockCount - 1
			Local rOff:Vector2 = rowOffset.Copy() 
			rOff.Scale(i) 
			position = Vector2.AddVectors(bottomRightBlockPosition, rOff) 
			For Local j:Int = 0 To bottomRowBlockCount - i - 1
				Local cOff:Vector2 = colOffset.Copy() 
				cOff.Scale(j) 
				Local rowPosition:Vector2 = Vector2.AddVectors(position, coff) 
				blockBody[blockCounter].SetPosition(rowPosition) 
				blockCounter:+1
			Next
		Next
	End Method
	
	Method Draw(image:TImage) 
		For Local body:TBody = EachIn blockBody
			SetOrigin(body.GetPosition().X, body.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(body.GetRotation())) 
			DrawImage(image, 0, 0) 
		Next
		SetOrigin(0, 0) 
		SetRotation(0) 
	End Method
End Type
